#include <iostream>
#include <cmath>
#include <string>
#include <algorithm>
#include <cstring>
#include <cstdio>
#include <fstream>
#include <cassert>
#include <map>
#include <set>
#include <vector>
#include <queue>
#include <stack>
#include <functional>
#include <numeric>
#include <ctime>
#include <cstdlib>
#include <sstream>

using namespace std;

#define f first
#define s second
#define mp make_pair
#define pb push_back
#define pii pair<int, int>
#define pll pair<long long, long long>
#define y1 stupid_y1
#define ll long long
#define vi vector<int>
#define forit(it, s) for(__typeof(s.begin()) it = s.begin(); it != s.end(); it++)
#define all(a) a.begin(), a.end()
#define sqr(x) ((x)*(x))
#define sz(a) (int)a.size()
#define file "a"

const int maxn = (int)1e3 + 11;
const int maxm = (int)1e4 + 11;
const int inf = int(1e9);
const int mod = inf + 7;
const double eps = 1e-9;
const double pi = acos(-1.0);

struct Edge {
	int to, from, cap, flow;
	Edge (int _from, int _to, int _cap, int _flow){
		to = _to;
		from = _from;
		cap = _cap;
		flow = _flow;
	}
	Edge (){}
};

Edge E[maxm];
int n, m, s, t;
vector < int > g[maxn];
int esz;
int d[maxn];
int ptr[maxn];
bool used[maxn];
int col[maxn];
int col2[maxn];
pii e[maxm];


void addEdge(int from, int to){
	E[esz++] = Edge(from, to, 1, 0);
	g[from].pb(esz-1);
	E[esz++] = Edge(to, from, 0, 0);
	g[to].pb(esz-1);
}

bool Bfs(int s, int t){
	for (int i=1;i<=n;i++) d[i] = used[i] = 0;
	queue < int > Q;
	Q.push(s);
	used[s] = true;
	while ( !Q.empty() ){
		int u = Q.front(); Q.pop();
		forit(it, g[u]){
			int id = *it;
			int to = E[id].to;
			if ( E[id].cap - E[id].flow > 0 && !used[to] ){
				d[to] = d[u] + 1;
				used[to] = true;
				Q.push(to);
			}
		}
	}
	return used[t];	
}

int dfs(int v, int t, int flow){
	if ( !flow ) return 0;
	if ( v == t ) return flow;
	for (; ptr[v] < sz(g[v]); ptr[v]++){
		int id = g[v][ptr[v]];
		int to = E[id].to;
		if ( d[v] + 1 != d[to] ) continue;
		int pushed = dfs(to, t, min(flow, E[id].cap - E[id].flow));
		if ( pushed ){
			E[id].flow += pushed;
			E[id^1].flow -= pushed;
			return pushed;
		}
	}
	return 0;
}

void clear(){
	esz = 0;
	for (int i=1;i<=n;i++){
		g[i].clear();
		col[i] = used[i] = col2[i] = 0;
	}
}

void dfs2(int v){
	col[v] = true;
	forit(it, g[v]){
		int id = *it;
		int to = E[id].to;
		if ( E[id].cap - E[id].flow > 0 && !col[to] ){
			dfs2(to);
		}
	}
}

void dfs3(int v){
	col2[v] = true;
	forit(it, g[v]){
		int id = *it;
		id ^= 1;
		int to = E[id].from;
		if ( E[id].cap - E[id].flow > 0 && !col2[to] ){
			dfs3(to);	
		}
	}	
}

bool solve(){
	scanf("%d%d%d%d", &n, &m, &s, &t);
	if ( !n && !m && !s && !t ) return false;

	clear();

	for (int i=0;i<m;i++){
		int x, y;
		scanf("%d%d", &x, &y);
		addEdge(x, y);
		e[i] = mp(x, y);
	}
	int total = 0;
	while(Bfs(s, t)){
		for (int i=1;i<=n;i++) ptr[i] = 0;
		while ( int pushed =  dfs(s, t, inf) ){
			total += pushed;
		}
	}

	dfs2(s);
	dfs3(t);

	vector < int > ans;

	for (int i=0;i<m;i++){
		int x = e[i].f;
		int y = e[i].s;
		if ( col[y] && col2[x] ){
			ans.pb(i+1);
		}
	}

	total += (sz(ans) > 0);

	printf("%d %d\n", total, sz(ans));

	return true;
}

int main () {

	#ifdef LOCAL
	freopen(file".in", "r", stdin);
	freopen(file".out", "w", stdout);
	#endif


	while(solve());






	#ifdef LOCAL
	cerr << (double)clock() * 1.0 / CLOCKS_PER_SEC << endl;
	#endif

	return 0;
}


